<?php
/**
 * 易谦微信扫码
 * @author mapeijian
 */
namespace app\common\pay;
use think\Request;
use app\common\Pay;
require_once(ROOT_PATH.'extend/ttcf/lib/Utils.php');

require_once(ROOT_PATH.'extend/ttcf/lib/Payment.php');
class TtcfAliScan extends Pay
{

    protected $code='';
    protected $error='';

    public function getCode()
    {
        return $this->code;
    }

    public function getError()
    {
        return $this->error;
    }

    public function order($outTradeNo,$subject,$totalAmount)
    {
       $pay = new \Payment($this->account->params->memberid,$this->account->params->key);
        $order = [];
     	$order['service'] = 'alipay.native';
    	$order['out_trade_no'] = $outTradeNo;
	    $order['amount'] = number_format($totalAmount,2,'.','');
	    $order['subject'] = $subject;
     	$result = $pay->commit($order);
         if(!$result){
            $this->code    =201;
            $this->error = '调用接口失败';
            return false;
        }
        
        if($result['code'] == 0){
            $this->code    =0;
            $obj           =new \stdClass();
            $obj->pay_url  =$result['data']['result'];

            if(Request::instance()->isMobile()) 
            {
                $obj->content_type = 1;
            } 
            else 
            {
                $obj->content_type = 1;
            }
    
            return $obj;
        }else{
            $this->code    =201;
            $this->error = isset($response['msg']) ? $response['msg'] : '支付失败';
            return false;
        }
    }

    /**
     * 页面回调
     */
    public function page_callback($params,$order)
    {
        header("Location:" . url('/orderquery',['orderid'=>$order->trade_no]));
    }

    /**
     * 服务器回调
     */
    public function notify_callback($params,$order)
    {
       if(\Utils::verifySign($this->account->params->key,$params)){
           if($params['status'] === 'FINISHED'){
			//订单支付成功  后续逻辑处理代码
			if ($order->total_price != $params['amount']) {
                    record_file_log('TtcfAliScan_notify_error', '金额异常！' . "\r\n" . $order->trade_no . "\r\n订单金额：{$order->total_price}，已支付：{$params['amount']}");
                    die('金额异常！');
                }
                $this->completeOrder($order);
                echo 'ok';
                return true;
           }else{
             exit('fail');   
           }
       }else{
          exit('fail'); 
       }
    }

    /**
     * @param $params
     * @return string
     */
    protected function sign($params, $apikey)
    {
        ksort($params);
        $keyStr = '';
        foreach ($params as $key => $val) {
            $keyStr .= "$key=$val&";
        }
        $sign = strtoupper(md5($keyStr . "key=" . $apikey));
        return $sign;
    }
}
?>